<?php
/**
 * 2007-2025 Your Company
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 *
 * @author    Net-assembly
 * @copyright 2007-2026 Net-assembly
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License (AFL 3.0)
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class CombinationValue extends ObjectModel
{
    public $id_ns_caisseconfig;
    public $combination_id;
    public $id_shop;
    public $combination_value;
    public $encoded_value;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = [
        'table' => 'ns_caisseconfig',
        'primary' => 'id_ns_caisseconfig',
        'multilang' => false,
        'fields' => [
            'combination_id' => ['type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => true],
            'id_shop' => ['type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => true],
            'combination_value' => ['type' => self::TYPE_STRING, 'validate' => 'isString'],
            'encoded_value' => ['type' => self::TYPE_STRING, 'validate' => 'isString'],
        ],
    ];

    /**
     * @param int $id_ns_caisseconfig
     * @return CombinationValue|null
     */
    public static function loadByIdCombination($id_ns_caisseconfig)
    {
        $result = Db::getInstance()->getRow('
            SELECT *
            FROM `' . _DB_PREFIX_ . 'ns_caisseconfig` sample
            WHERE sample.`id_ns_caisseconfig` = ' . (int) $id_ns_caisseconfig
        );

        return new CombinationValue($result['id_ns_caisseconfig']);
    }

    public static function getItems($id_shop)
    {
        $id_shop = ($id_shop !== false) ? $id_shop : Context::getContext()->shop->id;

        $sql = 'SELECT *
            FROM `' . _DB_PREFIX_ . 'ns_caisseconfig` sample
            WHERE sample.`id_shop`=' . (int) $id_shop . '
            ORDER  BY   sample.`id_ns_caisseconfig`  DESC
            ';

        return Db::getInstance()->executeS($sql);
    }

    public static function getDecliOne($id_shop)
    {
        $id_shop = ($id_shop !== false) ? $id_shop : Context::getContext()->shop->id;

        $sql = 'SELECT  sample.`encoded_value`
            FROM `' . _DB_PREFIX_ . 'ns_caisseconfig` sample
            WHERE sample.`id_shop` = ' . (int) $id_shop . '
            ';

        $results = Db::getInstance()->executeS($sql);

        return array_column($results, 'encoded_value');
    }

    public static function getDecliTwo($id_shop)
    {
        $id_shop = ($id_shop !== false) ? $id_shop : Context::getContext()->shop->id;

        $sql = 'SELECT  sample.`combination_id`
            FROM `' . _DB_PREFIX_ . 'ns_caisseconfig` sample
            WHERE sample.`id_shop` = ' . (int) $id_shop;

        $results = Db::getInstance()->executeS($sql);

        return array_column($results, 'combination_id');
    }

    public static function doReplace($decli)
    {
        $id_shop = Context::getContext()->shop->id;

        $decli_one = CombinationValue::getDecliOne($id_shop);

        $decli1 = [
            '%20',
            '-',
            '%C2%A0',
        ];

        foreach ($decli_one as $key => $val) {
            $decli1[] = $val;
        }

        $decliDva = [
            '',
            '_',
            '',
        ];

        $decli2 = array_merge($decliDva, CombinationValue::getDecliTwo($id_shop));

        $decli3 = str_replace($decli1, $decli2, $decli);

        return $decli3;
    }

    public static function verifyByNUmber($query)
    {
        return Db::getInstance()->getRow('
            SELECT iv.`id_ns_caisseconfig`
            FROM `' . _DB_PREFIX_ . 'ns_caisseconfig` iv
            WHERE iv.`combination_id`=' . (int) $query
        );
    }
}
